const db = require('./models');

async function checkUsers() {
  try {
    const users = await db.users.findAll();
    console.log('Users in database:');
    console.log('Total users:', users.length);
    
    users.forEach(user => {
      console.log(`- Username: ${user.username}`);
      console.log(`  Email: ${user.email}`);
      console.log(`  Status: ${user.status}`);
      console.log(`  Role: ${user.role}`);
      console.log(`  Created: ${user.createdAt}`);
      console.log('---');
    });
    
    process.exit(0);
  } catch (error) {
    console.error('Error checking users:', error);
    process.exit(1);
  }
}

checkUsers();