const { Sequelize } = require('sequelize');
const path = require('path');

// Initialize Sequelize with SQLite
const sequelize = new Sequelize({
  dialect: 'sqlite',
  storage: path.join(__dirname, 'database.sqlite'),
  logging: console.log
});

async function fixDatabase() {
  try {
    console.log('🔧 Fixing database schema...\n');
    
    // Check current columns
    console.log('📊 Current bkashTransactions columns:');
    const [currentColumns] = await sequelize.query(`
      PRAGMA table_info(bkashTransactions);
    `);
    
    const columnNames = currentColumns.map(col => col.name);
    console.log('Current columns:', columnNames);
    
    // Add missing columns if they don't exist
    if (!columnNames.includes('merchantAccountId')) {
      console.log('\n➕ Adding merchantAccountId column...');
      await sequelize.query(`
        ALTER TABLE bkashTransactions 
        ADD COLUMN merchantAccountId INTEGER;
      `);
      console.log('✅ merchantAccountId column added');
    } else {
      console.log('✅ merchantAccountId column already exists');
    }
    
    if (!columnNames.includes('accountNumberId')) {
      console.log('\n➕ Adding accountNumberId column...');
      await sequelize.query(`
        ALTER TABLE bkashTransactions 
        ADD COLUMN accountNumberId INTEGER;
      `);
      console.log('✅ accountNumberId column added');
    } else {
      console.log('✅ accountNumberId column already exists');
    }
    
    // Verify the changes
    console.log('\n📊 Updated bkashTransactions columns:');
    const [updatedColumns] = await sequelize.query(`
      PRAGMA table_info(bkashTransactions);
    `);
    
    updatedColumns.forEach(col => {
      console.log(`  - ${col.name}: ${col.type}`);
    });
    
    console.log('\n✅ Database schema fixed!');
    
  } catch (error) {
    console.error('❌ Error:', error.message);
  } finally {
    await sequelize.close();
  }
}

fixDatabase();