module.exports = (sequelize, Sequelize) => {
  const Agent = sequelize.define("agent", {
    id: {
      type: Sequelize.INTEGER,
      primaryKey: true,
      autoIncrement: true
    },
    name: {
      type: Sequelize.STRING,
      allowNull: false
    },
    company: {
      type: Sequelize.STRING
    },
    email: {
      type: Sequelize.STRING,
      validate: {
        isEmail: true
      }
    },
    phone: {
      type: Sequelize.STRING,
      allowNull: false
    },
    address: {
      type: Sequelize.TEXT
    },
    status: {
      type: Sequelize.ENUM('active', 'inactive'),
      defaultValue: 'active'
    },
    totalTransactions: {
      type: Sequelize.INTEGER,
      defaultValue: 0
    },
    balance: {
      type: Sequelize.DECIMAL(10, 2),
      defaultValue: 0
    }
  });

  return Agent;
};