module.exports = (sequelize, Sequelize) => {
  const BkashAccountNumber = sequelize.define("bkashAccountNumber", {
    id: {
      type: Sequelize.INTEGER,
      primaryKey: true,
      autoIncrement: true
    },
    accountType: {
      type: Sequelize.ENUM('agent', 'personal', 'merchant'),
      allowNull: false,
      comment: "Type of Bkash account"
    },
    accountNumber: {
      type: Sequelize.STRING(20),
      allowNull: false,
      comment: "Bkash account number (11 digits)"
    },
    accountName: {
      type: Sequelize.STRING(100),
      allowNull: false,
      comment: "Name associated with the account"
    },
    accountLabel: {
      type: Sequelize.STRING(50),
      allowNull: true,
      comment: "Custom label for easy identification"
    },
    isActive: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
      comment: "Whether this account is currently active"
    },
    isPrimary: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: false,
      comment: "Whether this is the primary account for this type"
    },
    notes: {
      type: Sequelize.TEXT,
      allowNull: true,
      comment: "Additional notes about this account"
    }
  }, {
    tableName: 'bkash_account_numbers',
    timestamps: true,
    indexes: [
      {
        unique: true,
        fields: ['accountNumber']
      },
      {
        unique: true,
        fields: ['accountType', 'isPrimary'],
        where: {
          isPrimary: true,
          isActive: true
        }
      }
    ],
    validate: {
      onlyOnePrimary() {
        // This will be handled by the unique index above
      }
    }
  });

  return BkashAccountNumber;
};