module.exports = (sequelize, Sequelize) => {
  const BkashTransaction = sequelize.define("bkashTransaction", {
    id: {
      type: Sequelize.INTEGER,
      primaryKey: true,
      autoIncrement: true
    },
    date: {
      type: Sequelize.DATEONLY,
      allowNull: false,
      defaultValue: Sequelize.literal('CURRENT_DATE')
    },
    time: {
      type: Sequelize.TIME,
      allowNull: false,
      defaultValue: Sequelize.literal('CURRENT_TIME')
    },
    type: {
      type: Sequelize.ENUM('sr_received', 'sr_given', 'bank_deposit', 'bank_withdraw', 'personal_sent', 'personal_received', 'merchant_sale', 'merchant_refund', 'merchant_withdrawal', 'merchant_fee'),
      allowNull: false,
      comment: "Type of transaction"
    },
    accountType: {
      type: Sequelize.ENUM('agent', 'personal', 'merchant'),
      allowNull: false,
      comment: "Whether this is for agent, personal, or merchant account"
    },
    amount: {
      type: Sequelize.DECIMAL(12, 2),
      allowNull: false,
      comment: "Transaction amount"
    },
    description: {
      type: Sequelize.STRING(500),
      allowNull: true,
      comment: "Transaction description"
    },
    reference: {
      type: Sequelize.STRING(100),
      allowNull: true,
      comment: "Transaction reference number"
    },
    counterparty: {
      type: Sequelize.STRING(200),
      allowNull: true,
      comment: "SR name, bank name, or person involved"
    },
    agentAccountId: {
      type: Sequelize.INTEGER,
      allowNull: true,
      references: {
        model: 'bkashAgentAccounts',
        key: 'id'
      },
      comment: "Reference to agent account if applicable"
    },
    personalAccountId: {
      type: Sequelize.INTEGER,
      allowNull: true,
      references: {
        model: 'bkashPersonalAccounts',
        key: 'id'
      },
      comment: "Reference to personal account if applicable"
    },
    merchantAccountId: {
      type: Sequelize.INTEGER,
      allowNull: true,
      references: {
        model: 'bkashMerchantAccounts',
        key: 'id'
      },
      comment: "Reference to merchant account if applicable"
    },
    accountNumberId: {
      type: Sequelize.INTEGER,
      allowNull: true,
      references: {
        model: 'bkashAccountNumbers',
        key: 'id'
      },
      comment: "Reference to specific account number used"
    },
    notes: {
      type: Sequelize.TEXT,
      allowNull: true,
      comment: "Additional notes"
    }
  }, {
    indexes: [
      {
        fields: ['date', 'type']
      },
      {
        fields: ['accountType', 'date']
      },
      {
        fields: ['agentAccountId']
      },
      {
        fields: ['personalAccountId']
      },
      {
        fields: ['merchantAccountId']
      },
      {
        fields: ['accountNumberId']
      }
    ]
  });

  return BkashTransaction;
};