module.exports = (sequelize, Sequelize) => {
  const CashReconciliation = sequelize.define('CashReconciliation', {
    id: {
      type: Sequelize.INTEGER,
      primaryKey: true,
      autoIncrement: true
    },
    date: {
      type: Sequelize.DATEONLY,
      allowNull: false,
      unique: true
    },
    // Opening note counts
    opening_5_notes: {
      type: Sequelize.INTEGER,
      defaultValue: 0,
      allowNull: false
    },
    opening_10_notes: {
      type: Sequelize.INTEGER,
      defaultValue: 0,
      allowNull: false
    },
    opening_20_notes: {
      type: Sequelize.INTEGER,
      defaultValue: 0,
      allowNull: false
    },
    opening_50_notes: {
      type: Sequelize.INTEGER,
      defaultValue: 0,
      allowNull: false
    },
    opening_100_notes: {
      type: Sequelize.INTEGER,
      defaultValue: 0,
      allowNull: false
    },
    opening_200_notes: {
      type: Sequelize.INTEGER,
      defaultValue: 0,
      allowNull: false
    },
    opening_500_notes: {
      type: Sequelize.INTEGER,
      defaultValue: 0,
      allowNull: false
    },
    opening_1000_notes: {
      type: Sequelize.INTEGER,
      defaultValue: 0,
      allowNull: false
    },
    // Closing note counts
    closing_5_notes: {
      type: Sequelize.INTEGER,
      defaultValue: 0,
      allowNull: true
    },
    closing_10_notes: {
      type: Sequelize.INTEGER,
      defaultValue: 0,
      allowNull: true
    },
    closing_20_notes: {
      type: Sequelize.INTEGER,
      defaultValue: 0,
      allowNull: true
    },
    closing_50_notes: {
      type: Sequelize.INTEGER,
      defaultValue: 0,
      allowNull: true
    },
    closing_100_notes: {
      type: Sequelize.INTEGER,
      defaultValue: 0,
      allowNull: true
    },
    closing_200_notes: {
      type: Sequelize.INTEGER,
      defaultValue: 0,
      allowNull: true
    },
    closing_500_notes: {
      type: Sequelize.INTEGER,
      defaultValue: 0,
      allowNull: true
    },
    closing_1000_notes: {
      type: Sequelize.INTEGER,
      defaultValue: 0,
      allowNull: true
    },
    // Calculated totals
    opening_total: {
      type: Sequelize.DECIMAL(10, 2),
      defaultValue: 0,
      allowNull: false
    },
    closing_total: {
      type: Sequelize.DECIMAL(10, 2),
      defaultValue: 0,
      allowNull: true
    },
    // Income and expense
    total_income: {
      type: Sequelize.DECIMAL(10, 2),
      defaultValue: 0,
      allowNull: false
    },
    total_expense: {
      type: Sequelize.DECIMAL(10, 2),
      defaultValue: 0,
      allowNull: false
    },
    // Variance
    variance: {
      type: Sequelize.DECIMAL(10, 2),
      defaultValue: 0,
      allowNull: true
    },
    // Notes
    notes: {
      type: Sequelize.TEXT,
      allowNull: true
    },
    // Status
    is_completed: {
      type: Sequelize.BOOLEAN,
      defaultValue: false,
      allowNull: false
    }
  }, {
    tableName: 'cash_reconciliations',
    hooks: {
      beforeSave: (instance) => {
        // Calculate opening total
        const openingTotal = (instance.opening_5_notes * 5) +
                            (instance.opening_10_notes * 10) +
                            (instance.opening_20_notes * 20) +
                            (instance.opening_50_notes * 50) +
                            (instance.opening_100_notes * 100) +
                            (instance.opening_200_notes * 200) +
                            (instance.opening_500_notes * 500) +
                            (instance.opening_1000_notes * 1000);
        instance.opening_total = openingTotal;

        // Calculate closing total if closing notes are provided
        if (instance.closing_5_notes !== null || instance.closing_10_notes !== null ||
            instance.closing_20_notes !== null || instance.closing_50_notes !== null ||
            instance.closing_100_notes !== null || instance.closing_200_notes !== null ||
            instance.closing_500_notes !== null || instance.closing_1000_notes !== null) {
          
          const closingTotal = ((instance.closing_5_notes || 0) * 5) +
                              ((instance.closing_10_notes || 0) * 10) +
                              ((instance.closing_20_notes || 0) * 20) +
                              ((instance.closing_50_notes || 0) * 50) +
                              ((instance.closing_100_notes || 0) * 100) +
                              ((instance.closing_200_notes || 0) * 200) +
                              ((instance.closing_500_notes || 0) * 500) +
                              ((instance.closing_1000_notes || 0) * 1000);
          instance.closing_total = closingTotal;

          // Calculate variance
          const expectedClosing = parseFloat(instance.opening_total) + 
                                 parseFloat(instance.total_income) - 
                                 parseFloat(instance.total_expense);
          instance.variance = parseFloat(instance.closing_total) - expectedClosing;
        }
      }
    }
  });

  return CashReconciliation;
};