const dbConfig = require("../config/db.config.js");
const Sequelize = require("sequelize");

const sequelize = new Sequelize({
  dialect: dbConfig.dialect,
  storage: dbConfig.storage,
  pool: {
    max: dbConfig.pool.max,
    min: dbConfig.pool.min,
    acquire: dbConfig.pool.acquire,
    idle: dbConfig.pool.idle
  },
  logging: dbConfig.logging
});

const db = {};

db.Sequelize = Sequelize;
db.sequelize = sequelize;

// Import models
db.products = require("./product.model.js")(sequelize, Sequelize);
db.categories = require("./category.model.js")(sequelize, Sequelize);
db.users = require("./user.model.js")(sequelize, Sequelize);
db.sales = require("./sale.model.js")(sequelize, Sequelize);
db.saleItems = require("./saleItem.model.js")(sequelize, Sequelize);
db.agents = require("./agent.model.js")(sequelize, Sequelize);
db.customers = require("./customer.model.js")(sequelize, Sequelize);
db.expenses = require("./expense.model.js")(sequelize, Sequelize);
db.bkashAgentAccounts = require("./bkashAgentAccount.model.js")(sequelize, Sequelize);
db.bkashPersonalAccounts = require("./bkashPersonalAccount.model.js")(sequelize, Sequelize);
db.bkashMerchantAccounts = require("./bkashMerchantAccount.model.js")(sequelize, Sequelize);
db.bkashAccountNumbers = require("./bkashAccountNumber.model.js")(sequelize, Sequelize);
db.bkashTransactions = require("./bkashTransaction.model.js")(sequelize, Sequelize);
db.mobileRechargeAccounts = require("./mobileRechargeAccount.model.js")(sequelize, Sequelize);
db.mobileRechargeTransactions = require("./mobileRechargeTransaction.model.js")(sequelize, Sequelize);
db.rechargeTransactions = require("./rechargeTransaction.model.js")(sequelize, Sequelize);
db.cashReconciliations = require("./cashReconciliation.model.js")(sequelize, Sequelize);
db.notes = require("./note.model.js")(sequelize, Sequelize);
db.dsoDeliveries = require("./dsoDelivery.model.js")(sequelize, Sequelize);
db.dsoAllocations = require("./dsoAllocation.model.js")(sequelize, Sequelize);

// Define relationships
db.categories.hasMany(db.products);
db.products.belongsTo(db.categories);

db.users.hasMany(db.sales);
db.sales.belongsTo(db.users);

db.customers.hasMany(db.sales);
db.sales.belongsTo(db.customers);

db.sales.hasMany(db.saleItems);
db.saleItems.belongsTo(db.sales);

db.products.hasMany(db.saleItems);
db.saleItems.belongsTo(db.products);

// Bkash relationships
db.bkashAgentAccounts.hasMany(db.bkashTransactions, { foreignKey: 'agentAccountId' });
db.bkashTransactions.belongsTo(db.bkashAgentAccounts, { foreignKey: 'agentAccountId' });

db.bkashPersonalAccounts.hasMany(db.bkashTransactions, { foreignKey: 'personalAccountId' });
db.bkashTransactions.belongsTo(db.bkashPersonalAccounts, { foreignKey: 'personalAccountId' });

db.bkashMerchantAccounts.hasMany(db.bkashTransactions, { foreignKey: 'merchantAccountId' });
db.bkashTransactions.belongsTo(db.bkashMerchantAccounts, { foreignKey: 'merchantAccountId' });

db.bkashAccountNumbers.hasMany(db.bkashTransactions, { foreignKey: 'accountNumberId' });
db.bkashTransactions.belongsTo(db.bkashAccountNumbers, { foreignKey: 'accountNumberId' });

// Mobile Recharge relationships
db.mobileRechargeAccounts.hasMany(db.mobileRechargeTransactions, { foreignKey: 'rechargeAccountId' });
db.mobileRechargeTransactions.belongsTo(db.mobileRechargeAccounts, { foreignKey: 'rechargeAccountId' });

// Notes relationships
db.users.hasMany(db.notes, { foreignKey: 'userId' });
db.notes.belongsTo(db.users, { foreignKey: 'userId' });

// DSO relationships
db.dsoDeliveries.hasMany(db.dsoAllocations, { foreignKey: 'deliveryId' });
db.dsoAllocations.belongsTo(db.dsoDeliveries, { foreignKey: 'deliveryId' });

module.exports = db;