module.exports = (sequelize, Sequelize) => {
  const Note = sequelize.define("note", {
    id: {
      type: Sequelize.INTEGER,
      primaryKey: true,
      autoIncrement: true
    },
    title: {
      type: Sequelize.STRING,
      allowNull: false,
      defaultValue: "Daily Note"
    },
    content: {
      type: Sequelize.TEXT,
      allowNull: false,
      defaultValue: ""
    },
    date: {
      type: Sequelize.DATEONLY,
      allowNull: false,
      defaultValue: Sequelize.literal('CURRENT_DATE')
    },
    type: {
      type: Sequelize.ENUM('note', 'todo'),
      allowNull: false,
      defaultValue: 'note'
    },
    isCompleted: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: false,
      comment: "For todo items - whether they are completed"
    },
    priority: {
      type: Sequelize.ENUM('low', 'medium', 'high'),
      allowNull: false,
      defaultValue: 'medium'
    },
    userId: {
      type: Sequelize.INTEGER,
      allowNull: false,
      references: {
        model: 'users',
        key: 'id'
      }
    }
  });

  return Note;
};