module.exports = (sequelize, Sequelize) => {
  const Payment = sequelize.define("payment", {
    id: {
      type: Sequelize.INTEGER,
      primaryKey: true,
      autoIncrement: true
    },
    amount: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false
    },
    type: {
      type: Sequelize.ENUM('payment', 'receipt'),
      allowNull: false
    },
    method: {
      type: Sequelize.ENUM('cash', 'bank', 'mobile'),
      defaultValue: 'cash'
    },
    reference: {
      type: Sequelize.STRING
    },
    notes: {
      type: Sequelize.TEXT
    },
    agentId: {
      type: Sequelize.INTEGER,
      references: {
        model: 'agents',
        key: 'id'
      }
    },
    userId: {
      type: Sequelize.INTEGER,
      references: {
        model: 'users',
        key: 'id'
      }
    }
  });

  return Payment;
};