const { DataTypes } = require('sequelize');

module.exports = (sequelize) => {
  const RechargeTransaction = sequelize.define('rechargeTransaction', {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false
    },
    customer_number: {
      type: DataTypes.STRING(20),
      allowNull: false,
      comment: 'Customer mobile number from bKash transaction'
    },
    transaction_id: {
      type: DataTypes.STRING(50),
      allowNull: false,
      unique: true,
      comment: 'Unique transaction ID from bKash'
    },
    amount: {
      type: DataTypes.DECIMAL(10, 2),
      allowNull: false,
      comment: 'Transaction amount'
    },
    old_balance: {
      type: DataTypes.DECIMAL(10, 2),
      allowNull: false,
      comment: 'Agent balance before transaction'
    },
    new_balance: {
      type: DataTypes.DECIMAL(10, 2),
      allowNull: false,
      comment: 'Agent balance after transaction'
    },
    commission: {
      type: DataTypes.DECIMAL(10, 2),
      allowNull: false,
      default: 0.00,
      comment: 'Commission earned from transaction'
    },
    transaction_type: {
      type: DataTypes.ENUM('cash_in', 'cash_out', 'mobile_recharge'),
      allowNull: false,
      comment: 'Type of bKash transaction'
    },
    ocr_confidence: {
      type: DataTypes.DECIMAL(5, 2),
      allowNull: true,
      comment: 'OCR confidence score (0-100)'
    },
    is_verified: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: false,
      comment: 'Whether transaction has been manually verified'
    },
    ocr_raw_text: {
      type: DataTypes.TEXT,
      allowNull: true,
      comment: 'Raw OCR text for debugging purposes'
    },
    notes: {
      type: DataTypes.TEXT,
      allowNull: true,
      comment: 'Additional notes or comments'
    }
  }, {
    tableName: 'recharge_transactions',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at',
    indexes: [
      {
        fields: ['customer_number']
      },
      {
        fields: ['transaction_id'],
        unique: true
      },
      {
        fields: ['created_at']
      },
      {
        fields: ['transaction_type']
      }
    ]
  });

  return RechargeTransaction;
};