module.exports = (sequelize, Sequelize) => {
  const SaleItem = sequelize.define("saleItem", {
    id: {
      type: Sequelize.INTEGER,
      primaryKey: true,
      autoIncrement: true
    },
    quantity: {
      type: Sequelize.INTEGER,
      allowNull: false,
      defaultValue: 1
    },
    unitPrice: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false
    },
    totalPrice: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false
    },
    discount: {
      type: Sequelize.DECIMAL(10, 2),
      defaultValue: 0
    }
  });

  return SaleItem;
};