const express = require('express');
const router = express.Router();
const auth = require("../controllers/auth.controller.js");
const { verifyToken } = require("../middleware/auth.middleware");

// Register a new user
router.post("/register", auth.register);

// User login
router.post("/login", auth.login);

// Get current user profile
router.get("/profile", verifyToken, auth.profile);

// Test endpoint for connectivity
router.get("/test", (req, res) => {
  res.json({ message: "API is working", timestamp: new Date().toISOString() });
});

module.exports = router;