const express = require("express");
const router = express.Router();
const bkashAccountNumberController = require("../controllers/bkashAccountNumber.controller");
const { verifyToken } = require("../middleware/auth.middleware");

// Apply authentication middleware to all routes
router.use(verifyToken);

// Get all account numbers
router.get("/", bkashAccountNumberController.getAllAccountNumbers);

// Get account numbers by type
router.get("/type/:accountType", bkashAccountNumberController.getAccountNumbersByType);

// Get primary account by type
router.get("/primary/:accountType", bkashAccountNumberController.getPrimaryAccountByType);

// Add new account number
router.post("/", bkashAccountNumberController.addAccountNumber);

// Update account number
router.put("/:id", bkashAccountNumberController.updateAccountNumber);

// Delete account number
router.delete("/:id", bkashAccountNumberController.deleteAccountNumber);

// Set primary account
router.patch("/:id/primary", bkashAccountNumberController.setPrimaryAccount);

// Toggle account status
router.patch("/:id/toggle-status", bkashAccountNumberController.toggleAccountStatus);

module.exports = router;