module.exports = app => {
  const bkashAccountNumbers = require("../controllers/bkashAccountNumbers.controller.js");
  const { verifyToken } = require("../middleware/auth.middleware.js");

  var router = require("express").Router();

  // Create a new bKash account number
  router.post("/", verifyToken, bkashAccountNumbers.create);

  // Retrieve all bKash account numbers
  router.get("/", verifyToken, bkashAccountNumbers.findAll);

  // Retrieve a single bKash account number with id
  router.get("/:id", verifyToken, bkashAccountNumbers.findOne);

  // Update a bKash account number with id
  router.put("/:id", verifyToken, bkashAccountNumbers.update);

  // Delete a bKash account number with id
  router.delete("/:id", verifyToken, bkashAccountNumbers.delete);

  // Set an account as primary
  router.put("/:id/set-primary", verifyToken, bkashAccountNumbers.setPrimary);

  app.use('/api/bkash-account-numbers', router);
};