const express = require("express");
const router = express.Router();
const bkashMerchantAccountController = require("../controllers/bkashMerchantAccount.controller");
const { verifyToken } = require("../middleware/auth.middleware");

// Apply authentication middleware to all routes
router.use(verifyToken);

// Get today's merchant account
router.get("/today", bkashMerchantAccountController.getTodayAccount);

// Get merchant account by date
router.get("/:date", bkashMerchantAccountController.getAccountByDate);

// Update merchant account
router.put("/:date", bkashMerchantAccountController.updateAccount);

// Get merchant account history
router.get("/", bkashMerchantAccountController.getAccountHistory);

// Get merchant transactions for a date
router.get("/:date/transactions", bkashMerchantAccountController.getTransactionsByDate);

// Add merchant transaction
router.post("/:date/transactions", bkashMerchantAccountController.addTransaction);

// Delete merchant transaction
router.delete("/transactions/:transactionId", bkashMerchantAccountController.deleteTransaction);

module.exports = router;