module.exports = app => {
  const bkashPersonal = require("../controllers/bkashPersonal.controller.js");
  const { verifyToken } = require("../middleware/auth.middleware");

  var router = require("express").Router();

  // Create or update personal account
  router.post("/", verifyToken, bkashPersonal.createOrUpdate);

  // Retrieve all personal accounts
  router.get("/", verifyToken, bkashPersonal.findAll);

  // Retrieve today's personal account
  router.get("/today", verifyToken, bkashPersonal.findToday);

  // Retrieve summary statistics
  router.get("/summary", verifyToken, bkashPersonal.getSummary);

  // Retrieve personal account by date
  router.get("/:date", verifyToken, bkashPersonal.findByDate);

  // Get transactions for a specific date
  router.get("/:date/transactions", verifyToken, bkashPersonal.getTransactions);

  // Add a transaction
  router.post("/transaction", verifyToken, bkashPersonal.addTransaction);

  // Close day (update closing balance)
  router.put("/close", verifyToken, bkashPersonal.closeDay);

  // Delete personal account by date
  router.delete("/:date", verifyToken, bkashPersonal.delete);

  app.use('/api/bkash-personal', router);
};