const express = require("express");
const router = express.Router();
const bkashTransactionsController = require("../controllers/bkashTransactions.controller");
const { verifyToken } = require("../middleware/auth.middleware");

// Apply authentication middleware to all routes
router.use(verifyToken);

// Get transactions with filters (account type, account number, date range)
router.get("/", bkashTransactionsController.getTransactions);

// Get account balance and profit for a specific account and date range
router.get("/account-summary", bkashTransactionsController.getAccountSummary);

// Get combined report for all accounts
router.get('/combined-report', bkashTransactionsController.getCombinedReport);

// Save opening/closing balance
router.post('/save-balance', bkashTransactionsController.saveBalance);

module.exports = router;