const express = require('express');
const router = express.Router();
const dsoController = require('../controllers/dso.controller');

// DSO Delivery routes
router.post('/deliveries', dsoController.createDelivery);
router.get('/deliveries', dsoController.getDeliveries);
router.get('/deliveries/:id', dsoController.getDeliveryById);
router.put('/deliveries/:id', dsoController.updateDelivery);

// DSO Allocation routes
router.post('/allocations', dsoController.createAllocation);
router.get('/allocations', dsoController.getAllocations);
router.get('/allocations/today', dsoController.getTodayAllocations);

// Sales tracking routes
router.post('/sales/record', dsoController.recordSale);

// Reporting routes
router.get('/reports/daily', dsoController.getDailyReport);

// Utility routes
router.get('/dso-names', dsoController.getDSONames);

module.exports = router;