module.exports = app => {
  const notes = require("../controllers/note.controller.js");
  const { verifyToken } = require("../middleware/auth.middleware");

  var router = require("express").Router();

  // Create a new note
  router.post("/", verifyToken, notes.create);

  // Retrieve all notes for the authenticated user
  router.get("/", verifyToken, notes.findAll);

  // Retrieve today's notes for the authenticated user
  router.get("/today", verifyToken, notes.findToday);

  // Retrieve a single note with id
  router.get("/:id", verifyToken, notes.findOne);

  // Update a note with id
  router.put("/:id", verifyToken, notes.update);

  // Delete a note with id
  router.delete("/:id", verifyToken, notes.delete);

  // Toggle completion status for todo items
  router.patch("/:id/toggle", verifyToken, notes.toggleComplete);

  app.use('/api/notes', router);
};