const express = require('express');
const router = express.Router();
const products = require("../controllers/product.controller.js");
const { verifyToken } = require("../middleware/auth.middleware");

// Apply authentication middleware to all routes
router.use(verifyToken);

// Create a new Product
router.post("/", products.create);

// Retrieve all Products
router.get("/", products.findAll);

// Retrieve a single Product with id
router.get("/:id", products.findOne);

// Retrieve a Product by barcode
router.get("/barcode/:barcode", products.findByBarcode);

// Update a Product with id
router.put("/:id", products.update);

// Update stock quantity
router.patch("/:id/stock", products.updateStock);

// Delete a Product with id
router.delete("/:id", products.delete);

// Delete all Products
router.delete("/", products.deleteAll);

module.exports = router;