const express = require('express');
const router = express.Router();
const rechargeTransactionController = require('../controllers/rechargeTransaction.controller');
const authMiddleware = require('../middleware/auth');

// Apply authentication middleware to all routes
router.use(authMiddleware);

// Create a new recharge transaction
router.post('/', rechargeTransactionController.create);

// Get all recharge transactions with filters and pagination
router.get('/', rechargeTransactionController.getAll);

// Get daily summary report
router.get('/daily-summary', rechargeTransactionController.getDailySummary);

// Get a single recharge transaction by ID
router.get('/:id', rechargeTransactionController.getById);

// Update a recharge transaction
router.put('/:id', rechargeTransactionController.update);

// Verify a transaction
router.patch('/:id/verify', rechargeTransactionController.verify);

// Delete a recharge transaction
router.delete('/:id', rechargeTransactionController.delete);

module.exports = router;