const http = require('http');

// Test function to check Bkash API endpoints
async function testBkashAPI() {
  console.log('Testing Bkash API endpoints...');
  
  // First, let's test without authentication to see the error
  console.log('\n1. Testing without authentication:');
  await makeRequest('/api/bkash-agent/today');
  await makeRequest('/api/bkash-personal/today');
  await makeRequest('/api/bkash-merchant/today');
  await makeRequest('/api/bkash-account-numbers');
  
  console.log('\n2. Testing with invalid token:');
  await makeRequest('/api/bkash-agent/today', 'Bearer invalid_token');
  
  console.log('\nTest completed.');
}

function makeRequest(path, authHeader = null) {
  return new Promise((resolve) => {
    const options = {
      hostname: 'localhost',
      port: 5000,
      path: path,
      method: 'GET',
      headers: {}
    };
    
    if (authHeader) {
      options.headers['Authorization'] = authHeader;
    }
    
    const req = http.request(options, (res) => {
      let data = '';
      
      res.on('data', (chunk) => {
        data += chunk;
      });
      
      res.on('end', () => {
        console.log(`${path}: Status ${res.statusCode}`);
        if (res.statusCode !== 200) {
          console.log(`  Response: ${data}`);
        }
        resolve();
      });
    });
    
    req.on('error', (err) => {
      console.log(`${path}: Error - ${err.message}`);
      resolve();
    });
    
    req.end();
  });
}

// Run the test
testBkashAPI().catch(console.error);