import React from 'react';
import { BrowserRouter as Router, Routes, Route } from 'react-router-dom';
import { Container } from 'react-bootstrap';
import 'bootstrap/dist/css/bootstrap.min.css';
import './App.css';

// Layout Components
import MainLayout from './components/layout/MainLayout';

// Auth Pages
import Login from './pages/auth/Login';
import Register from './pages/auth/Register';

// Dashboard Pages
import Dashboard from './pages/Dashboard';

// Product Pages
import ProductList from './pages/products/ProductList';
import AddProduct from './pages/products/AddProduct';
import EditProduct from './pages/products/EditProduct';

// Sales Pages
import POS from './pages/sales/POS';
import SalesList from './pages/sales/SalesList';
import Invoice from './pages/sales/Invoice';

// Agent Pages
import AgentList from './pages/agents/AgentList';
import AddAgent from './pages/agents/AddAgent';

// User Pages
import UserList from './pages/users/UserList';
import AddUser from './pages/users/AddUser';

// Report Pages
import SalesReport from './pages/reports/SalesReport';
import ProductReport from './pages/reports/ProductReport';

// Extra Features
import CustomerList from './pages/customers/CustomerList';
import ExpenseList from './pages/expenses/ExpenseList';

// Bkash Pages
import BkashAccounts from './pages/bkash/BkashAccounts';
import BkashAccountSelection from './pages/bkash/BkashAccountSelection';
import BkashMerchantAccount from './pages/bkash/BkashMerchantAccount';
import BkashAccountNumbers from './pages/bkash/BkashAccountNumbers';
import BkashAgentManagement from './pages/bkash/BkashAgentManagement';
import BkashReports from './pages/bkash/BkashReports';
import BkashOCRCapture from './pages/bkash/BkashOCRCapture';
import BkashSmsTransactions from './pages/bkash/BkashSmsTransactions';

// Mobile Recharge Pages
import MobileRecharge from './pages/mobile-recharge/MobileRecharge';

// Cash Box Pages
import CashBox from './pages/cash-box/CashBox';
import CashBoxReports from './pages/cash-box/CashBoxReports';

// Palli Bidyut Pages
import CustomerManagement from './pages/palli-bidyut/CustomerManagement';
import BillCollection from './pages/palli-bidyut/BillCollection';
import PendingBills from './pages/palli-bidyut/PendingBills';
import DueDateTracking from './pages/palli-bidyut/DueDateTracking';
import PalliBidyutReports from './pages/palli-bidyut/PalliBidyutReports';

// Auth Provider
import { AuthProvider } from './contexts/AuthContext';
import PrivateRoute from './components/auth/PrivateRoute';

function App() {
  return (
    <Router>
      <AuthProvider>
        <div className="app-container">
          <Routes>
            <Route path="/login" element={<Login />} />
            <Route path="/register" element={<Register />} />
            
            <Route path="/" element={
              <PrivateRoute>
                <MainLayout>
                  <Dashboard />
                </MainLayout>
              </PrivateRoute>
            } />
            
            {/* Dashboard Route */}
            <Route path="/dashboard" element={
              <PrivateRoute>
                <MainLayout>
                  <Dashboard />
                </MainLayout>
              </PrivateRoute>
            } />
            
            {/* Product Routes */}
            <Route path="/products" element={
              <PrivateRoute>
                <MainLayout>
                  <ProductList />
                </MainLayout>
              </PrivateRoute>
            } />
            
            <Route path="/products/add" element={
              <PrivateRoute>
                <MainLayout>
                  <AddProduct />
                </MainLayout>
              </PrivateRoute>
            } />
            
            <Route path="/products/edit/:id" element={
              <PrivateRoute>
                <MainLayout>
                  <EditProduct />
                </MainLayout>
              </PrivateRoute>
            } />
            
            {/* POS Route */}
            <Route path="/pos" element={
              <PrivateRoute>
                <MainLayout>
                  <POS />
                </MainLayout>
              </PrivateRoute>
            } />
            
            {/* Sales Routes */}
            <Route path="/sales" element={
              <PrivateRoute>
                <MainLayout>
                  <SalesList />
                </MainLayout>
              </PrivateRoute>
            } />
            
            <Route path="/sales/invoice/:id" element={
              <PrivateRoute>
                <MainLayout>
                  <Invoice />
                </MainLayout>
              </PrivateRoute>
            } />
            
            {/* Agent Routes */}
            <Route path="/agents" element={
              <PrivateRoute>
                <MainLayout>
                  <AgentList />
                </MainLayout>
              </PrivateRoute>
            } />
            
            <Route path="/agents/add" element={
              <PrivateRoute>
                <MainLayout>
                  <AddAgent />
                </MainLayout>
              </PrivateRoute>
            } />
            
            {/* Bkash Routes */}
            <Route path="/bkash" element={
              <PrivateRoute>
                <MainLayout>
                  <BkashAccounts />
                </MainLayout>
              </PrivateRoute>
            } />
            
            <Route path="/bkash/account-selection" element={
              <PrivateRoute>
                <MainLayout>
                  <BkashAccountSelection />
                </MainLayout>
              </PrivateRoute>
            } />
            
            <Route path="/bkash/merchant" element={
              <PrivateRoute>
                <MainLayout>
                  <BkashMerchantAccount />
                </MainLayout>
              </PrivateRoute>
            } />
            
            <Route path="/bkash/account-numbers" element={
              <PrivateRoute>
                <MainLayout>
                  <BkashAccountNumbers />
                </MainLayout>
              </PrivateRoute>
            } />
            
            <Route path="/bkash/agent-management" element={
              <PrivateRoute>
                <MainLayout>
                  <BkashAgentManagement />
                </MainLayout>
              </PrivateRoute>
            } />
            
            <Route path="/bkash/reports" element={
              <PrivateRoute>
                <MainLayout>
                  <BkashReports />
                </MainLayout>
              </PrivateRoute>
            } />
            
            <Route path="/bkash/ocr-capture" element={
              <PrivateRoute>
                <MainLayout>
                  <BkashOCRCapture />
                </MainLayout>
              </PrivateRoute>
            } />
            
            <Route path="/bkash/sms-transactions" element={
              <PrivateRoute>
                <MainLayout>
                  <BkashSmsTransactions />
                </MainLayout>
              </PrivateRoute>
            } />
            
            {/* Mobile Recharge Routes */}
            <Route path="/mobile-recharge" element={
              <PrivateRoute>
                <MainLayout>
                  <MobileRecharge />
                </MainLayout>
              </PrivateRoute>
            } />
            
            {/* Cash Box Routes */}
            <Route path="/cash-box" element={
              <PrivateRoute>
                <MainLayout>
                  <CashBox />
                </MainLayout>
              </PrivateRoute>
            } />
            
            <Route path="/cash-box/reports" element={
              <PrivateRoute>
                <MainLayout>
                  <CashBoxReports />
                </MainLayout>
              </PrivateRoute>
            } />
            
            {/* User Routes */}
            <Route path="/users" element={
              <PrivateRoute>
                <MainLayout>
                  <UserList />
                </MainLayout>
              </PrivateRoute>
            } />
            
            <Route path="/users/add" element={
              <PrivateRoute>
                <MainLayout>
                  <AddUser />
                </MainLayout>
              </PrivateRoute>
            } />
            
            {/* Report Routes */}
            <Route path="/reports/sales" element={
              <PrivateRoute>
                <MainLayout>
                  <SalesReport />
                </MainLayout>
              </PrivateRoute>
            } />
            
            <Route path="/reports/products" element={
              <PrivateRoute>
                <MainLayout>
                  <ProductReport />
                </MainLayout>
              </PrivateRoute>
            } />
            
            {/* Customer Routes */}
            <Route path="/customers" element={
              <PrivateRoute>
                <MainLayout>
                  <CustomerList />
                </MainLayout>
              </PrivateRoute>
            } />
            
            {/* Expense Routes */}
            <Route path="/expenses" element={
              <PrivateRoute>
                <MainLayout>
                  <ExpenseList />
                </MainLayout>
              </PrivateRoute>
            } />
            
            {/* Palli Bidyut Routes */}
            <Route path="/palli-bidyut/customer-management" element={
              <PrivateRoute>
                <MainLayout>
                  <CustomerManagement />
                </MainLayout>
              </PrivateRoute>
            } />
            
            <Route path="/palli-bidyut/bill-collection" element={
              <PrivateRoute>
                <MainLayout>
                  <BillCollection />
                </MainLayout>
              </PrivateRoute>
            } />
            
            <Route path="/palli-bidyut/pending-bills" element={
              <PrivateRoute>
                <MainLayout>
                  <PendingBills />
                </MainLayout>
              </PrivateRoute>
            } />
            
            <Route path="/palli-bidyut/due-date-tracking" element={
              <PrivateRoute>
                <MainLayout>
                  <DueDateTracking />
                </MainLayout>
              </PrivateRoute>
            } />
            
            <Route path="/palli-bidyut/reports" element={
              <PrivateRoute>
                <MainLayout>
                  <PalliBidyutReports />
                </MainLayout>
              </PrivateRoute>
            } />
          </Routes>
        </div>
      </AuthProvider>
    </Router>
  );
}

export default App;