import React from 'react';
import { Navbar, Nav, Dropdown } from 'react-bootstrap';
import { FaBars, FaUser, FaBell, FaSignOutAlt } from 'react-icons/fa';
import './Header.css';

const Header = ({ toggleSidebar, onLogout }) => {
  // Mock user data - in a real app, this would come from context or state
  const user = JSON.parse(localStorage.getItem('user')) || { 
    fullName: 'Admin User', 
    role: 'Administrator' 
  };
  
  return (
    <Navbar className="header" expand="lg">
      <div className="d-flex align-items-center">
        <button className="sidebar-toggle" onClick={toggleSidebar}>
          <FaBars />
        </button>
      </div>
      
      <Nav className="ms-auto">
        <Dropdown align="end" className="me-3">
          <Dropdown.Toggle variant="link" id="notification-dropdown" className="nav-icon">
            <FaBell />
            <span className="badge">3</span>
          </Dropdown.Toggle>
          <Dropdown.Menu>
            <Dropdown.Header>Notifications</Dropdown.Header>
            <Dropdown.Item>New sale completed</Dropdown.Item>
            <Dropdown.Item>Low stock alert: Product A</Dropdown.Item>
            <Dropdown.Item>Payment received from Agent</Dropdown.Item>
            <Dropdown.Divider />
            <Dropdown.Item className="text-center">View All</Dropdown.Item>
          </Dropdown.Menu>
        </Dropdown>
        
        <Dropdown align="end">
          <Dropdown.Toggle variant="link" id="user-dropdown" className="nav-icon user-dropdown">
            <div className="avatar">
              <FaUser />
            </div>
            <div className="user-info d-none d-md-block">
              <div className="user-name">{user.fullName}</div>
              <div className="user-role">{user.role}</div>
            </div>
          </Dropdown.Toggle>
          <Dropdown.Menu>
            <Dropdown.Item>Profile</Dropdown.Item>
            <Dropdown.Item>Settings</Dropdown.Item>
            <Dropdown.Divider />
            <Dropdown.Item onClick={onLogout}>
              <FaSignOutAlt className="me-2" /> Logout
            </Dropdown.Item>
          </Dropdown.Menu>
        </Dropdown>
      </Nav>
    </Navbar>
  );
};

export default Header;