import React from 'react';
import { Link, useLocation } from 'react-router-dom';
import { Nav, Dropdown } from 'react-bootstrap';
import { 
  FaHome, 
  FaBoxOpen, 
  FaShoppingCart, 
  FaUsers, 
  FaChartBar, 
  FaCog,
  FaWarehouse,
  FaMobileAlt,
  FaChartLine,
  FaStore,
  FaCreditCard,
  FaEye,
  FaCashRegister,
  FaBolt,
  FaUserFriends,
  FaMoneyBillWave,
  FaClipboardList,
  FaBell,
  FaFileAlt,
  FaUserCog
} from 'react-icons/fa';
import './Sidebar.css';

const Sidebar = ({ isOpen }) => {
  const location = useLocation();
  
  // Check if the current path matches the nav item path
  const isActive = (path) => {
    return location.pathname === path || location.pathname.startsWith(`${path}/`);
  };
  
  return (
    <div className={`sidebar ${isOpen ? 'open' : 'closed'}`}>
      <div className="sidebar-header">
        <h3>POS System</h3>
      </div>
      
      <Nav className="flex-column">
        <Nav.Item>
          <Link 
            to="/" 
            className={`nav-link ${isActive('/') ? 'active' : ''}`}
          >
            <FaHome className="icon" />
            <span>Dashboard</span>
          </Link>
        </Nav.Item>
        
        <Nav.Item>
          <Link 
            to="/products" 
            className={`nav-link ${isActive('/products') ? 'active' : ''}`}
          >
            <FaBoxOpen className="icon" />
            <span>Products</span>
          </Link>
        </Nav.Item>
        
        <Nav.Item>
          <Link 
            to="/inventory" 
            className={`nav-link ${isActive('/inventory') ? 'active' : ''}`}
          >
            <FaWarehouse className="icon" />
            <span>Inventory</span>
          </Link>
        </Nav.Item>
        
        <Nav.Item>
          <Link 
            to="/pos" 
            className={`nav-link ${isActive('/pos') ? 'active' : ''}`}
          >
            <FaShoppingCart className="icon" />
            <span>POS</span>
          </Link>
        </Nav.Item>
        
        <Nav.Item>
          <Link 
            to="/sales" 
            className={`nav-link ${isActive('/sales') ? 'active' : ''}`}
          >
            <FaShoppingCart className="icon" />
            <span>Sales</span>
          </Link>
        </Nav.Item>
        
        <Nav.Item>
          <Link 
            to="/agents" 
            className={`nav-link ${isActive('/agents') ? 'active' : ''}`}
          >
            <FaUsers className="icon" />
            <span>Agents</span>
          </Link>
        </Nav.Item>
        
        <Nav.Item>
          <Link 
            to="/expenses" 
            className={`nav-link ${isActive('/expenses') ? 'active' : ''}`}
          >
            <FaMoneyBillWave className="icon" />
            <span>Daily Expenses</span>
          </Link>
        </Nav.Item>
        
        <Dropdown as={Nav.Item} className="sidebar-dropdown">
          <Dropdown.Toggle 
            as="div" 
            className={`nav-link ${isActive('/bkash') ? 'active' : ''}`}
            style={{ cursor: 'pointer' }}
          >
            <FaMobileAlt className="icon" />
            <span>Bkash</span>
          </Dropdown.Toggle>
          <Dropdown.Menu>
            <Dropdown.Item as={Link} to="/bkash">
              <FaMobileAlt className="me-2" />
              Account Management
            </Dropdown.Item>
            <Dropdown.Item as={Link} to="/bkash/account-selection">
              <FaEye className="me-2" />
              Account Selection
            </Dropdown.Item>
            <Dropdown.Item as={Link} to="/bkash/merchant">
              <FaStore className="me-2" />
              Merchant Account
            </Dropdown.Item>
            <Dropdown.Item as={Link} to="/bkash/account-numbers">
              <FaCreditCard className="me-2" />
              Account Numbers
            </Dropdown.Item>
            <Dropdown.Item as={Link} to="/bkash/agent-management">
              <FaUserCog className="me-2" />
              Agent Management
            </Dropdown.Item>
            <Dropdown.Item as={Link} to="/bkash/reports">
              <FaChartLine className="me-2" />
              Reports
            </Dropdown.Item>
            <Dropdown.Item as={Link} to="/bkash/ocr-capture">
              <FaEye className="me-2" />
              OCR Transaction Entry
            </Dropdown.Item>
            <Dropdown.Item as={Link} to="/bkash/sms-transactions">
              <FaBell className="me-2" />
              SMS Transactions
            </Dropdown.Item>
          </Dropdown.Menu>
        </Dropdown>
        
        <Nav.Item>
          <Link 
            to="/mobile-recharge" 
            className={`nav-link ${isActive('/mobile-recharge') ? 'active' : ''}`}
          >
            <FaMobileAlt className="icon" />
            <span>Mobile Recharge</span>
          </Link>
        </Nav.Item>
        
        <Dropdown as={Nav.Item} className="sidebar-dropdown">
          <Dropdown.Toggle 
            as="div" 
            className={`nav-link ${isActive('/cash-box') ? 'active' : ''}`}
            style={{ cursor: 'pointer' }}
          >
            <FaCashRegister className="icon" />
            <span>Cash Box</span>
          </Dropdown.Toggle>
          <Dropdown.Menu>
            <Dropdown.Item as={Link} to="/cash-box">
              <FaCashRegister className="me-2" />
              Daily Reconciliation
            </Dropdown.Item>
            <Dropdown.Item as={Link} to="/cash-box/reports">
              <FaChartLine className="me-2" />
              Reports
            </Dropdown.Item>
          </Dropdown.Menu>
        </Dropdown>
        
        <Dropdown as={Nav.Item} className="sidebar-dropdown">
          <Dropdown.Toggle 
            as="div" 
            className={`nav-link ${isActive('/palli-bidyut') ? 'active' : ''}`}
            style={{ cursor: 'pointer' }}
          >
            <FaBolt className="icon" />
            <span>পল্লী বিদ্যুৎ</span>
          </Dropdown.Toggle>
          <Dropdown.Menu>
            <Dropdown.Item as={Link} to="/palli-bidyut/customers">
              <FaUserFriends className="me-2" />
              গ্রাহক ব্যবস্থাপনা
            </Dropdown.Item>
            <Dropdown.Item as={Link} to="/palli-bidyut/bill-collection">
              <FaMoneyBillWave className="me-2" />
              বিল সংগ্রহ
            </Dropdown.Item>
            <Dropdown.Item as={Link} to="/palli-bidyut/pending-bills">
              <FaClipboardList className="me-2" />
              বকেয়া বিল
            </Dropdown.Item>
            <Dropdown.Item as={Link} to="/palli-bidyut/due-tracking">
              <FaBell className="me-2" />
              মেয়াদ ট্র্যাকিং
            </Dropdown.Item>
            <Dropdown.Item as={Link} to="/palli-bidyut/reports">
              <FaFileAlt className="me-2" />
              রিপোর্ট
            </Dropdown.Item>
          </Dropdown.Menu>
        </Dropdown>
        
        <Nav.Item>
          <Link 
            to="/reports" 
            className={`nav-link ${isActive('/reports') ? 'active' : ''}`}
          >
            <FaChartBar className="icon" />
            <span>Reports</span>
          </Link>
        </Nav.Item>
        
        <Nav.Item>
          <Link 
            to="/settings" 
            className={`nav-link ${isActive('/settings') ? 'active' : ''}`}
          >
            <FaCog className="icon" />
            <span>Settings</span>
          </Link>
        </Nav.Item>
      </Nav>
      
      <div className="sidebar-footer">
        <p>v1.0.0</p>
      </div>
    </div>
  );
};

export default Sidebar;