import React, { useState, useEffect } from 'react';
import { Container, Row, Col, Card, Nav, Tab, Tabs, Alert } from 'react-bootstrap';
import { useAuth } from '../../contexts/AuthContext';
import BkashAgentAccount from './BkashAgentAccount';
import BkashPersonalAccount from './BkashPersonalAccount';
import BkashMerchantAccount from './BkashMerchantAccount';
import './BkashAccounts.css';

const BkashAccounts = () => {
  const { currentUser } = useAuth();
  const [activeTab, setActiveTab] = useState('agent');
  const [alert, setAlert] = useState({ show: false, message: '', variant: 'success' });

  const showAlert = (message, type = 'success') => {
    setAlert({ show: true, message, variant: type });
    setTimeout(() => setAlert({ show: false, message: '', variant: 'success' }), 3000);
  };

  return (
    <Container fluid className="bkash-accounts-container">
      <Row className="mb-4">
        <Col>
          <h2 className="page-title">
            <i className="fas fa-mobile-alt me-2"></i>
            Bkash Account Management
          </h2>
          <p className="text-muted">Manage your Bkash Agent, Personal, and Merchant accounts</p>
        </Col>
      </Row>

      {alert.show && (
        <Row className="mb-3">
          <Col>
            <Alert variant={alert.variant} dismissible onClose={() => setAlert({ show: false, message: '', variant: 'success' })}>
              {alert.message}
            </Alert>
          </Col>
        </Row>
      )}

      <Row>
        <Col>
          <Card className="shadow-sm">
            <Card.Body>
              <Tabs
                activeKey={activeTab}
                onSelect={(k) => setActiveTab(k)}
                className="mb-3 custom-tabs"
              >
                <Tab eventKey="agent" title={
                  <span>
                    <i className="fas fa-user-tie me-2"></i>
                    Agent Account
                  </span>
                }>
                  <BkashAgentAccount showAlert={showAlert} />
                </Tab>
                
                <Tab eventKey="personal" title={
                  <span>
                    <i className="fas fa-user me-2"></i>
                    Personal Account
                  </span>
                }>
                  <BkashPersonalAccount showAlert={showAlert} />
                </Tab>
                
                <Tab eventKey="merchant" title={
                  <span>
                    <i className="fas fa-store me-2"></i>
                    Merchant Account
                  </span>
                }>
                  <BkashMerchantAccount showAlert={showAlert} />
                </Tab>
              </Tabs>
            </Card.Body>
          </Card>
        </Col>
      </Row>
    </Container>
  );
};

export default BkashAccounts;