@echo off
echo ========================================
echo    POS System Startup Script
echo ========================================
echo.

REM Check if Node.js is installed
node --version >nul 2>&1
if %errorlevel% neq 0 (
    echo ERROR: Node.js is not installed!
    echo.
    echo Please install Node.js from: https://nodejs.org/
    echo Choose the LTS version and restart this script after installation.
    echo.
    pause
    exit /b 1
)

echo Node.js is installed. Proceeding with setup...
echo.

REM Navigate to backend directory and install dependencies
echo Installing backend dependencies...
cd /d "%~dp0backend"
if not exist "node_modules" (
    echo Running npm install for backend...
    npm install
    if %errorlevel% neq 0 (
        echo ERROR: Failed to install backend dependencies!
        pause
        exit /b 1
    )
) else (
    echo Backend dependencies already installed.
)

REM Navigate to frontend directory and install dependencies
echo.
echo Installing frontend dependencies...
cd /d "%~dp0frontend"
if not exist "node_modules" (
    echo Running npm install for frontend...
    npm install
    if %errorlevel% neq 0 (
        echo ERROR: Failed to install frontend dependencies!
        pause
        exit /b 1
    )
) else (
    echo Frontend dependencies already installed.
)

echo.
echo ========================================
echo    Starting POS System Servers
echo ========================================
echo.

REM Start backend server in a new window
echo Starting backend server on port 5000...
cd /d "%~dp0backend"
start "POS Backend Server" cmd /k "echo Backend Server Starting... && npm start"

REM Wait a moment for backend to start
timeout /t 3 /nobreak >nul

REM Start frontend server in a new window
echo Starting frontend server on port 3000...
cd /d "%~dp0frontend"
start "POS Frontend Server" cmd /k "echo Frontend Server Starting... && npm start"

echo.
echo ========================================
echo    POS System Started Successfully!
echo ========================================
echo.
echo Backend Server: http://localhost:5000
echo Frontend Application: http://localhost:3000
echo.
echo Default Login Credentials:
echo Username: admin
echo Password: admin123
echo.
echo Both servers are starting in separate windows.
echo Wait for both to fully load, then open your browser to:
echo http://localhost:3000
echo.
echo Press any key to exit this window...
pause >nul